#include "DDialogo.h"

namespace DWL {
            
	//! Destructor  
    /*! Destructor por defecto.
		    \fn		   ~DDialogo(void);
            \return     No devuelve nada
    */
    DDialogo::~DDialogo(void) { 
        Destruir();
	};
 
    //! Funcin que crea el dialogo.
    /*!	Esta funcin crea el dialogo.
	        \fn			HWND Crear(const UINT ID_Dialogo, const int cX, const int cY, DBaseWnd *nPadre);
	        \param[in]	ID_Dialogo	: ID del dialogo en los recursos.
	        \param[in]	cX			: Posicin X. Puedes especificar DWL_CENTRADO para que se centre.
	        \param[in]	cY			: Posicin Y. Puedes especificar DWL_CENTRADO para que se centre.
            \param[in]	nPadre    	: Clase DBaseWnd que hace de padre (NULL en caso de ser un dialogo padre)
	        \return		Devuelve el HWND del dialogo. En caso de error devolver NULL.
    */
    HWND DDialogo::Crear(const UINT ID_Dialogo, const int cX, const int cY, DBaseWnd *nPadre) {
		if (_hWnd != NULL) Destruir();

        _AgregarAppBaseWnd(ID_Dialogo, nPadre);
        
        HWND hWndPadre = NULL;
        if (nPadre != NULL) hWndPadre = nPadre->hWnd();

        _hWnd = CreateDialogParam(GetModuleHandle(NULL), MAKEINTRESOURCE(ID_Dialogo), hWndPadre, (DLGPROC)_GestorMensajes, (LPARAM)this); 
//        SetWindowTheme(_hWnd, TEXT("Explorer"), NULL);
		RECT RC; 
		GetWindowRect(_hWnd, &RC); 	

        Mover(cX, cY, RC.right - RC.left, RC.bottom - RC.top); 

		return _hWnd;
	};

    //! Funcin virtual para determinar si la ventana es maximizable.
    /*! Esta funcin virtual determina si la ventana es maximizable.
		    \fn			virtual void Maximizable(const bool nMax);
		    \param[in]	nMax : Especifica true para que la ventana sea maximizable, false para lo contrario.
		    \return		Esta funcin no devuelve nada.
    */
    void DDialogo::Maximizable(const bool nMax) { 
		LONG_PTR Estilos = GetWindowLongPtr(_hWnd, GWL_STYLE); 
		if (Estilos & WS_MAXIMIZEBOX)	Estilos = Estilos & ~ WS_MAXIMIZEBOX;  
		if (nMax == true)				Estilos = Estilos | WS_MAXIMIZEBOX;
		SetWindowLongPtr(_hWnd, GWL_STYLE, Estilos); 
	};

    //! Funcin virtual que nos dice si la ventana es maximizable.
    /*! Esta funcin virtual nos dice si la ventana es maximizable.
		    \fn			virtual const bool Maximizable(void);
		    \return		Devuelve true si la ventana es maximizable, false en caso contrario.
    */
    const bool DDialogo::Maximizable(void) {
		LONG_PTR Estilos = GetWindowLongPtr(_hWnd, GWL_STYLE); 
		if (Estilos & WS_MAXIMIZEBOX) return true; 
		else                          return false;
	};

    //! Funcin que nos dice si la ventana esta maximizada en este momento.
    /*! Esta funcin nos dice si la ventana esta maximizada en este momento.
		    \fn			const bool Maximizada(void);
		    \return		Devuelve true si la ventana esta maximizada, false en caso contrario.
    */
    const bool DDialogo::Maximizada(void) {
		WINDOWPLACEMENT WndPl;
		GetWindowPlacement(_hWnd, &WndPl);
		if (WndPl.showCmd == SW_MAXIMIZE) return true;
		return false;
	};

    //! Funcin virtual para determinar si la ventana es minimizable.
    /*! Esta funcin virtual determina si la ventana es minimizable.
		    \fn			virtual void Minimizable(const bool nMin);
		    \param[in]	nMix : Especifica true para que la ventana sea minimizable, false para lo contrario.
		    \return		Esta funcin no devuelve nada.
    */
    void DDialogo::Minimizable(const bool nMin) { 
		LONG_PTR Estilos = GetWindowLongPtr(_hWnd, GWL_STYLE);
		if (Estilos & WS_MINIMIZEBOX)	Estilos = Estilos & ~ WS_MINIMIZEBOX; 
		if (nMin == true)				Estilos = Estilos | WS_MINIMIZEBOX; 
		SetWindowLongPtr(_hWnd, GWL_STYLE, Estilos); 
	};

    //! Funcin virtual que nos dice si la ventana es minimizable.
    /*! Esta funcin virtual nos dice si la ventana es minimizable.
		    \fn			virtual const bool Minimizable(void);
		    \return		Devuelve true si la ventana es minimizable, false en caso contrario.
    */
    const bool DDialogo::Minimizable(void) { 
		LONG_PTR Estilos = GetWindowLongPtr(_hWnd, GWL_STYLE); 
		if (Estilos & WS_MINIMIZEBOX) return true; 
		else						  return false;
	};

    //! Funcin que nos dice si la ventana esta minimizada en este momento.
    /*! Esta funcin nos dice si la ventana esta minimizada en este momento.
		    \fn			const bool Minimizada(void);
		    \return		Devuelve true si la ventana esta minimizada, false en caso contrario.
    */
    const bool DDialogo::Minimizada(void) {
		WINDOWPLACEMENT WndPl;
		GetWindowPlacement(_hWnd, &WndPl);
		if (WndPl.showCmd == SW_MINIMIZE) return true;
		return false;
	};

    //! Funcin para posicionar la ventana siempre delante de todas las otras ventanas.
    /*! Esta funcin posiciona la ventana siempre delante de todas las otras ventanas.
		    \fn			virtual void SiempreDelante(const bool SD);
		    \param[in]	SD : Especifica true para que la ventana quede siempre por delante, false para que tenga un comportamiento normal segun su coordenada Z.
		    \return		Esta funcin no devuelve nada.
            \remarks    Por norma las ventanas se posicionan utilizando el OrdenZ, que es un indice para determinar en que posicin estan las ventanas. 
                        Si por ejemplo creas dos ventanas la primera se pondra en el orden 1, y la segunda en el orden 0, 
                        de forma que si se crean en cascada deberias ver la segunda ventana por delante de todo.
    */
    void DDialogo::SiempreDelante(const bool SD) {
        SetWindowPos(_hWnd, (SD ? HWND_TOPMOST : HWND_TOP), 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE); // NTY
//        if (SD == true) SetWindowPos(_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE); // NTY
//		else			SetWindowPos(_hWnd, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);		// NTY
	};

    //! Funcin para asignar el titulo de la ventana.
    /*! Esta funcin asigna el titulo de la ventana.
		    \fn			void Titulo(const TCHAR *Txt);
		    \param[in]	Txt : Nuevo texto para el titulo de la ventana.
		    \return		Esta funcin no devuelve nada.
    */
    void DDialogo::Titulo(const TCHAR *Txt) {
		SetWindowText(_hWnd, Txt);
	};

    //! Funcin para obtener el titulo de la ventana.
    /*! Esta funcin obtiene el titulo de la ventana en el buffer especificado.
		    \fn			void Titulo(const TCHAR *Txt);
		    \param[in]	Txt    : Buffer de texto para obtener el titulo.
            \param[in]  TamTxt : Tamao del buffer para el titulo.
		    \return		Esta funcin devuelve 0 en caso de error. En caso de exito devuelve el numero de caracteres que contiene el titulo sin incluir el terminador NULL.
    */
    int DDialogo::Titulo(TCHAR *Txt, const int TamTxt) { 
		return GetWindowText(_hWnd, Txt, TamTxt);
	};


	//! Esqueleto inicial que enlaza esta clase con la ventana.
	/*! Esta funcin es el esqueleto inicial que enlaza esta clase con la ventana.
			\fn			static INT_PTR CALLBACK _GestorMensajes(HWND hWndDialogo, UINT uMsg, WPARAM wParam, LPARAM lParam);
			\param[in]	HandleVentana	: Identificador de ventana.
			\param[in]	uMsg			: Mensaje.
			\param[in]	wParam			: Parametro1.
			\param[in]	lParam			: Parametro2.
			\return		Dependiendo del mensaje y los parametros devuelve una cosa o otra.
	*/
    INT_PTR CALLBACK DDialogo::_GestorMensajes(HWND hWndDialogo, UINT uMsg, WPARAM wParam, LPARAM lParam) {
		switch (uMsg) {
			case WM_INITDIALOG : {
				DDialogo *PreDialogo = reinterpret_cast<DDialogo *>(lParam);
				PreDialogo->_hWnd = hWndDialogo;
				SetWindowLongPtr(hWndDialogo, GWLP_USERDATA, (long)lParam);
				PreDialogo->GestorMensajes(uMsg, wParam, lParam);
				return TRUE;
			}

            // CUSTOM DRAW (ListView y TreeView)
            case WM_NOTIFY : // OJO WM_NOTIFY debe ir encima de default: no le pongo un break porque solo quiero saber si es un CUSTOMDRAW, en caso contrario se debe tratar como un mensaje normal
                if (((LPNMHDR)lParam)->code == NM_CUSTOMDRAW)
                    return SendMessage(((LPNMHDR)lParam)->hwndFrom, DWL_CUSTOM_DRAWDLG, wParam, lParam);
			default : {
				DDialogo *Dialogo = reinterpret_cast<DDialogo *>(GetWindowLongPtr(hWndDialogo, GWLP_USERDATA));
				if (Dialogo == NULL) return FALSE;
//                    if (Dialogo == NULL) return DefDlgProc(HandleDialogo, uMsg, wParam, lParam);
                INT_PTR Ret = Dialogo->GestorMensajes(uMsg, wParam, lParam);
                if (Ret == DWL_USAR_GESTOR_POR_DEFECTO) return FALSE;
//                    if (Ret == DWL_USAR_GESTOR_POR_DEFECTO) return DefDlgProc(HandleDialogo, uMsg, wParam, lParam);
                return Ret;
			}
		}
	};


};
